<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductColor extends Model 
{

    protected $table = 'products_colors';
    public $timestamps = true;
    protected $fillable = array('product_id', 'color_id');

    public function product()
    {
        return $this->hasMany('App\Models\Product', 'product_id');
    }

    public function color()
    {
        return $this->belongsToMany('App\Models\Color', 'color_id');
    }

}